<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // FIX: Ensure table is fresh to prevent ID type mismatch (INT vs UUID)
        Schema::dropIfExists('fee_batches');

        Schema::create('fee_batches', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->unsignedBigInteger('supplier_id'); // Manufacturer/Supplier

            // Batch Details
            $table->date('dispatch_date');
            $table->string('courier_ref')->nullable(); // TCS/Leopard tracking
            $table->integer('qty');
            $table->decimal('rate', 10, 2);

            // Financials
            $table->decimal('expected_amount', 15, 2);
            $table->decimal('received_amount', 15, 2)->default(0);
            $table->decimal('deduction_amount', 15, 2)->default(0); // For rejected slips

            // Status
            $table->string('status')->default('Pending'); // Pending, Partial, Cleared
            $table->text('notes')->nullable();

            $table->timestamps();

            $table->foreign('supplier_id')->references('id')->on('suppliers');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('fee_batches');
    }
};
