<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
// use Illuminate\Database\Eloquent\Concerns\HasUuids; // Uncomment if on Laravel 10+

class PurchaseOrder extends Model
{
    // If using Laravel 10+, use this trait:
    // use HasUuids;

    // CRITICAL FIX FOR UUIDs:
    protected $keyType = 'string';
    public $incrementing = false;

    protected $guarded = [];

    protected $casts = [
        'date' => 'date',
        'expected_date' => 'date',
    ];

    public function items()
    {
        return $this->hasMany(PurchaseOrderItem::class);
    }

    public function supplier()
    {
        return $this->belongsTo(Supplier::class);
    }
}
