<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ProductAttribute extends Model
{
    use HasFactory;

    protected $fillable = ['type', 'value'];

    /**
     * Scope to fetch only specific types.
     */
    public function scopeByType($query, $type)
    {
        return $query->where('type', $type);
    }
}
