<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    protected $guarded = [];

    protected $casts = [
        'price' => 'decimal:2',
        'cost' => 'decimal:2',
    ];

    public function stockUnits()
    {
        return $this->hasMany(StockUnit::class);
    }

    // Accessor for easier display
    public function getFullNameAttribute()
    {
        return "{$this->make} {$this->model} ({$this->year} - {$this->color})";
    }
}
