<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\{Customer, Supplier};

class PeopleController extends Controller
{
    // --- CUSTOMERS ---

    public function storeCustomer(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'fatherName' => 'nullable|string|max:255',
            'cnic' => 'nullable|string|max:50',
            'contact' => 'nullable|string|max:50',
            'address' => 'nullable|string',
            'guarantorName' => 'nullable|string|max:255',
            'status' => 'nullable|string'
        ]);

        Customer::updateOrCreate(
            ['id' => $request->id], // If ID exists, update. If null, create new (Auto-Inc).
            [
                'name' => $request->name,
                'father_name' => $request->fatherName,
                'cnic' => $request->cnic,
                'contact' => $request->contact,
                'address' => $request->address,
                'guarantor_name' => $request->guarantorName,
                'guarantor_father_name' => $request->guarantorFatherName,
                'guarantor_address' => $request->guarantorAddress,
                'notes' => $request->notes,
                'ref_number' => $request->refNumber,
                'status' => $request->status ?? 'Active'
            ]
        );

        return back()->with('message', $request->id ? 'Customer Updated' : 'Customer Created');
    }

    public function destroyCustomer($id)
    {
        $customer = Customer::findOrFail($id);
        // Check for dependencies (Sales) before deleting if strict
        if($customer->sales()->exists()) {
            return back()->withErrors(['error' => 'Cannot delete customer with active sales history.']);
        }
        $customer->delete();
        return back()->with('message', 'Customer Deleted');
    }

    // --- SUPPLIERS ---

    public function storeSupplier(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'contact' => 'nullable|string|max:50'
        ]);

        Supplier::updateOrCreate(
            ['id' => $request->id],
            [
                'name' => $request->name,
                'person' => $request->person,
                'contact' => $request->contact,
                'email' => $request->email,
                'address' => $request->address,
                'notes' => $request->notes,
                'ref_number' => $request->refNumber,
                'status' => $request->status ?? 'Active'
            ]
        );

        return back()->with('message', $request->id ? 'Supplier Updated' : 'Supplier Added');
    }

    public function destroySupplier($id)
    {
        $supplier = Supplier::findOrFail($id);
        if($supplier->purchaseOrders()->exists()) {
            return back()->withErrors(['error' => 'Cannot delete supplier with existing purchase orders.']);
        }
        $supplier->delete();
        return back()->with('message', 'Supplier Removed');
    }
}
